#!/bin/bash
#

# Script variables
declare SCRIPT_NAME="${0##*/}"
declare SCRIPT_DIR="$(cd ${0%/*} ; pwd)"
declare ROOT_DIR="$PWD"

echo 
echo "SCRIPT_NAME: ${SCRIPT_NAME}"
echo "SCRIPT_DIR: ${SCRIPT_DIR}"
echo "ROOT_DIR: ${ROOT_DIR}"
echo

# Detect proper usage
if [ "$#" -ne "3" ] ; then
  echo -e "ERROR: Usage: $0 <username> <passwd> <my_repo.lst>"
  exit 1
fi

## Script variables
USERNAME="${1}"
PASSWD="${2}"
REPO_FILE="${3}"

for repo in $(cat ${REPO_FILE}) ; do
  PROJECT_NAME="${repo}"
  PROJECT_PATH="${ROOT_DIR}/${PROJECT_NAME}"
  # Make sure the required directories don't exist
  if [ -e "${PROJECT_PATH}" ] ; then
    echo -e "ERROR: Project ${PROJECT_NAME} already exists!"
  else
    # create the new project
    echo -e "INFO: Creating new git repository ${PROJECT_NAME}..."
    echo -e "===================================================="
    cd ${ROOT_DIR}
    mkdir ${PROJECT_NAME}
    cd ${PROJECT_PATH}
    git init
    echo "#README" > README.md
    # Since this is a new repository we need to have at least one commit
    git add README.md
    git commit --quiet -m "[Project] Initial Master Repo Commit"
    #create remote repository
    curl -X POST -v -u "${USERNAME}:${PASSWD}" https://api.bitbucket.org/2.0/repositories/halfaker/${PROJECT_NAME} -H "Content-Type: application/json" -d '{"scm": "git", "is_private": true, "project": {"key": "MCCF"}}'
    
    USERORIGIN="https://${USERNAME}:${PASSWD}@bitbucket.org/halfaker/${PROJECT_NAME}.git"
    git remote add origin https://bitbucket.org/halfaker/${PROJECT_NAME}.git
    git push -u ${USERORIGIN} --all
    git push -u ${USERORIGIN} --tags
    echo
  fi
done